<?php
/****************************************
 * XKLog 后台管理页
 *
 * 此文件控制输出后台管理页
 *
 * 更新：2009-06-23
 * 版本：V1.0
 ****************************************/

require('../include/loader.php');
@header("content-Type: text/html; charset=utf-8");

if( !user_is_super_admin() ){
	//SafeLogger("试图直接访问后台页面 admin_style.php 。")
	//SafeDefender()
	show_admin_message( '您尚未登录，或者登录已过期' );
	exit;
}

$action = getGP( 'action', 'G' );

switch( $action ) {
    case 'EditStyle':
        edit_style();
    	break;
}

function edit_style() {
	global $db;
	$db->query( "UPDATE `" . PREFIX_STR . "Set` SET Style='" . getGP('name','G') . "'" );
	cache_set();
	show_admin_message( '应用新风格成功', 'admin_style.php' );
	exit;
}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title><?php echo $_CACHE['set'][0]['BlogName'] ?> - 后台管理</title>
	<link rel = "stylesheet" type = "text/css" href = "../Include/Style.css" />
	<style>
		.theme {float:left;width:400px;height:135px;margin:5px;padding:5px;border:1px solid #ccc;overflow:hidden;}
		.theme dt {float:left;margin-right:5px;}
		.theme dt img {width:140px;height:130px;padding:2px;border:1px solid #ccc;background:#fff;}
		.theme a:hover img {border:1px solid #000;}
		.theme .theme_name {font-size:14px;font-weight:bold;}
		.theme dd {margin:0;padding:0;font-size:12px;}
		.current {background:#FFFFCE;border:1px solid #333;}
	</style>
</head>
<body id = "Admin_Body">
<div id = "Admin_Main">
<center>

	<div class = "Admin_Panel">
		<div class = "Admin_Title">风格管理</div>
		<div class = "Admin_Content">
<?php

switch( $action ) {
    default:
        main();
}

function main() {
	global $_CACHE;
?>
			<form action="Admin_BaseSet.asp?id=1" method="post">
				<fieldset>
				<legend> 风格列表</legend>
					<div align="left">      
						<?php
							$theme_root = XKLOG_ROOT . 'style/';
							$result = read_dir($theme_root);
							$cur_theme = $_CACHE['set'][0]['Style'];
							$themes = array();
							foreach ($result as $each_dir) {
								$each_dir = str_replace($theme_root, '', $each_dir);
								if( !style_is_legal( $each_dir ) ) continue;
								$themes[$each_dir]['directory'] = $each_dir;
								$themes[$each_dir]['path'] = 'style/' . $each_dir . '/';
								$infofile = XKLOG_ROOT . $themes[$each_dir]['path'].'info.xml';
								$info = parse_theme_info( $infofile );
								$themes[$each_dir] = array_merge( $themes[$each_dir], $info );
							}
							foreach ($themes as $theme) {
						?>
							<dl class="theme<?php if ($theme['directory'] == $cur_theme) echo ' current';?>">
								<dt><a href="admin_style.php?action=EditStyle&name=<?php echo $theme['directory']?>" title="应用该主题"><img src="<?php echo BLOG_PATH . $theme['path'].$theme['thumb']?>" /></a></dt>
								<dd class="theme_name"><?=$theme['name']?></dd>
								<dd>作者：<?php echo $theme['author']?></dd>
								<dd>版本：<?php echo $theme['version']?></dd>
								<dd>时间：<?php echo $theme['pubdate']?></dd>
								<dd>主页：<a href="<?php echo $theme['homepage']?>" target="_blank"><?php echo $theme['homepage']?></a></dd>
								<dd title="<?php echo $theme['intro']?>">简介：<?php echo cut_str($theme['intro'],60)?></dd>
							</dl>
						<?php }?>
					</div>
				</fieldset>
				<div class="Main_Button"></div>
			</form>
<?php
}
/*
//=================================
// 代码编辑器
//=================================
Sub CodeEditor
	dim source
	source = Temp_Load( Request.QueryString("file") )
    source = Replace(source, ">", "&gt;")
    source = Replace(source, "<", "&lt;")
	%>
	<form action="Admin_Style.asp?action=EditTemplate&name=<%= Request.QueryString("file") %>" method="post">
		<div style="height:420px;">
			<div style="float:left;border:1px solid #808080;width:15%;height:385px;margin:10px;">
				<div style="height:180px;padding:2px;text-align:left;">
					<b>模板列表：</b>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Main.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Main.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Head.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Head.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Foot.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Foot.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Side.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Side.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Widget.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Widget.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Article.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Article.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Comment.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Comment.html</a>
					<br /><a href="Admin_Style.asp?action=CodeEditor&file=Message.html"><img border="0" src="../Include/htm.gif" style="margin:4px 3px -3px 0px" />Message.html</a>
				</div>
				<div style="height:205px;padding:2px;text-align:left;">
					<b>帮助与提示：</b>
				</div>
			</div>
			<div style="width:75%;height:365px;border:1px solid #808080;margin:10px;padding:10px;float:left">
				<b>当前模板：<%= Request.QueryString("file") %></b><br /><br />
				<textarea name="myCode" wrap="on" style="width:100%;height:336px;"><%=source%></textarea>
			</div>
		</div>
		<input type="submit" name="Submit" class="Main_Button" value="保存" />
	</form>
	<div class="Main_Button"></div>
	<%
End Sub
*/

function read_dir($path) {
	$dirs = array();
	if (is_dir($path)) {
		if ($d = opendir($path)) {
			while ( ($dir = readdir($d)) !== false ) {
				if ( $dir != '.' && $dir != '..' ) {
					if ( is_dir($path.$dir) ) {
						$dirs[] = $path.$dir;
					}
				}
			}
		}
		@closedir($d);
	}
	return $dirs;
}

function style_is_legal( $each_dir ) {
	if( !file_exists( XKLOG_ROOT . 'style/' . $each_dir . '/info.xml' ) ) return false;
	// 检查 css 、模板？
	return true;
}

function parse_theme_info( $xml_file ) {
	$fp = fopen($xml_file, 'rb');
	$content = fread($fp, filesize($xml_file));
	preg_match_all('/<name>(.+?)<\/name>/is',$content, $name);
	preg_match_all('/<author>(.*?)<\/author>/is',$content, $author);
	preg_match_all('/<version>(.*?)<\/version>/is',$content, $version);
	preg_match_all('/<pubdate>(.*?)<\/pubdate>/is',$content, $pubdate);
	preg_match_all('/<homepage>(.*?)<\/homepage>/is',$content, $homepage);
	preg_match_all('/<thumb>(.*?)<\/thumb>/is',$content, $thumb);
	preg_match_all('/<intro>(.*?)<\/intro>/is',$content, $intro);
	$info = array(
		'name' => $name[1][0],
		'author' => $author[1][0],
		'version' => $version[1][0],
		'pubdate' => $pubdate[1][0],
		'homepage' => $homepage[1][0],
		'thumb' => $thumb[1][0],
		'intro' => $intro[1][0],
	);
	return $info;
}
?>

		</div>
	</div>

	<div id="Foot"><?php show_run_info() ?></div>
</center>
</div>
</body>
</html>